// Postfix calculator

#import <stdio.h>
#import <Foundation/Foundation.h>
#import "StackOfInteger.h"
#import "PostfixCalculator.h"

//------- @implementation section -------
#define ADD "+"
#define SUB "="
#define DIV "/"
#define MUL "*"
#define SPACE " "

@implementation PostfixCalculator;

- (id) initWithExpression: (NSString *) postFixExpression{
    calculatorStack = [[StackOfInteger alloc] init];
    expression = postFixExpression;
    return self;
}

+ (PostfixCalculator*) CreateWithExpression: (NSString *) postFixExpression{
    PostfixCalculator* newCalculator = [[PostfixCalculator alloc] init];
    newCalculator->calculatorStack = [[StackOfInteger alloc] init];
    newCalculator->expression = postFixExpression;
    return newCalculator;
}

- (NSString*) getExpression{
    return expression;
}

- (int) calculate
{
    BOOL done=NO;
    NSArray* expressionComponents = [expression componentsSeparatedByString:@SPACE];
    NSLog(@"Expression Components >%@<", expressionComponents);
    int k=0;
    while (done == NO){
        NSString* expressionElement = [expressionComponents objectAtIndex:k];
        NSLog(@"Expression Element >%@<", expressionElement);
        if([expressionElement isEqualToString:@ADD]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 + intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else if([expressionElement isEqualToString:@SUB]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 - intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else if([expressionElement isEqualToString:@DIV]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 / intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else if([expressionElement isEqualToString:@MUL]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 * intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else {
            int intValue = [expressionElement intValue];
            [calculatorStack push:intValue];
            printf("Pushing >%d<\n", intValue);
        }
        printf("in calculate loop\n");
        k++;
        if ( k == [expressionComponents count]) done = YES;
    }
    printf("outside calculate loop\n");
    int finalResult = [calculatorStack pop];
    return finalResult;
}

+ (void) printClassDescription{
    printf("In printClassDescription\n");
}

@end

